package ru.yandex.chemodan.videostreaming.framework.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.videostreaming.framework.web.BannedIpRegistry;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.commune.zk2.client.ZkManagerContextConfiguration;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import(ZkManagerContextConfiguration.class)
public class BannedIpConfig {
    @Autowired
    private ZkManager zkManager;

    @Autowired
    @Qualifier("zkRoot")
    private ZkPath zkRoot;

    @Bean
    public BannedIpRegistry bannedIpRegistry() {
        return new BannedIpRegistry(zkManager, zkRoot.child("banned-ips"));
    }
}
