package ru.yandex.chemodan.videostreaming.framework.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.videostreaming.framework.hls.HlsOutputProvider;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.receiver.FFmpegReceiverManager;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.receiver.FFmpegReceiverServlet;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
public class FFmpegReceiverOutputConfig implements HlsOutputConfig {
    @Autowired
    @SuppressWarnings({"SpringAutowiredFieldsWarningInspection", "SpringJavaAutowiringInspection"})
    private HlsCachingSourceProxyParams params;

    @Bean
    @Override
    public HlsOutputProvider hlsOutputProvider() {
        return ffmpegReceiverManager();
    }

    @Bean
    public FFmpegReceiverServlet ffmpegReceiverServlet() {
        return new FFmpegReceiverServlet(ffmpegReceiverManager());
    }

    @Bean
    protected FFmpegReceiverManager ffmpegReceiverManager() {
        return new FFmpegReceiverManager(params.proxyPort);
    }
}
