package ru.yandex.chemodan.videostreaming.framework.config;

import lombok.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFPaths;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Value
public class FFmpegVersions {
    public static final String VER_3_2 = "32";

    public static final String VER_4_1 = "41";

    MapF<String, FFPaths> versionToPaths;

    public static FFmpegVersions single(String version, String ffmpeg, String ffprobe) {
        return new FFmpegVersions(Cf.map(version, new FFPaths(ffmpeg, ffprobe)));
    }

    public ListF<String> getVersions() {
        return versionToPaths.keys().sorted();
    }

    public FFPaths get(String version) {
        return versionToPaths.getTs(version);
    }
}
