package ru.yandex.chemodan.videostreaming.framework.config;

import ru.yandex.misc.dataSize.DataSize;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsCachingSourceProxyParams {
    @SuppressWarnings("unused")
    public static final HlsCachingSourceProxyParams DEFAULT =
            new HlsCachingSourceProxyParams(
                    "proxy",
                    10011,
                    75,
                    DataSize.fromMegaBytes(1),
                    1
            );

    public final String proxyUrlPrefix;

    public final int proxyPort;

    public final int cacheSize;

    public final DataSize cacheDataSize;

    public final int upstreamRetryCount;

    public HlsCachingSourceProxyParams(String proxyUrlPrefix, int proxyPort, int cacheSize, DataSize cacheDataSize,
            int upstreamRetryCount)
    {
        this.proxyUrlPrefix = proxyUrlPrefix;
        this.proxyPort = proxyPort;
        this.cacheSize = cacheSize;
        this.cacheDataSize = cacheDataSize;
        this.upstreamRetryCount = upstreamRetryCount;
    }
}
