package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DurationEstimator extends DefaultObject {
    private final Instant startedAt;

    private final Duration totalDuration;

    private final double speed;

    private DurationEstimator(Instant startedAt, Duration totalDuration, double speed) {
        this.startedAt = startedAt;
        this.totalDuration = totalDuration;
        this.speed = speed;
    }

    public static Option<DurationEstimator> consO(Instant startedAt, Instant reportedAt, Duration reportedDuration,
            Duration totalDuration)
    {
        double speed = calcSpeed(startedAt, reportedAt, reportedDuration);
        return Option.when(speed > 0, new DurationEstimator(startedAt, totalDuration, speed));
    }

    private static double calcSpeed(Instant startedAt, Instant reportedAt, Duration reportedDuration) {
        Duration tillReportDuration = new Duration(startedAt, reportedAt);
        return !tillReportDuration.isEqual(Duration.ZERO)
                ? 1.0 * reportedDuration.getMillis() / tillReportDuration.getMillis()
                : 0;
    }

    public Duration estimateRealLeftOverDuration() {
        return zeroIfNegative(estimateRealLeftOverDuration(Instant.now()));
    }

    public Duration estimateRealLeftOverDuration(Instant at) {
        return estimateRealTotalDuration().minus(estimateRealPassedDuration(at));
    }

    private Duration estimateRealTotalDuration() {
        return toReal(totalDuration);
    }

    private Duration estimateRealPassedDuration(Instant at) {
        return new Duration(startedAt, at);
    }

    private Duration toReal(Duration duration) {
        return Duration.millis((long) (duration.getMillis() / speed));
    }

    private static Duration zeroIfNegative(Duration result) {
        return result.getMillis() > 0 ? result : Duration.ZERO;
    }
}
