package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import org.joda.time.Instant;
import org.joda.time.Seconds;
import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DurationEstimatorTest {
    @Test
    public void estimateRemainingTgtDuration() {
        Instant start = Instant.now();
        Instant inBetween = start.plus(Seconds.seconds(5).toStandardDuration());
        Instant now = start.plus(Seconds.seconds(10).toStandardDuration());
        Assert.equals(
                Seconds.seconds(5).toStandardDuration(),
                DurationEstimator.consO(
                        start,
                        inBetween,
                        Seconds.seconds(10).toStandardDuration(),
                        Seconds.seconds(30).toStandardDuration()
                ).get().estimateRealLeftOverDuration(now)
        );
    }
}
