package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.Validate;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFPaths extends DefaultObject {
    private final File2 ffmpeg;

    private final File2 ffprobe;

    public FFPaths(String ffmpeg, String ffprobe) {
        this(new File2(ffmpeg), new File2(ffprobe));
    }

    public FFPaths(File2 ffmpeg, File2 ffprobe) {
        validatePath("FFmpeg", ffmpeg);
        validatePath("FFprobe", ffprobe);
        this.ffmpeg = ffmpeg;
        this.ffprobe = ffprobe;
    }

    public FFPaths withFFmpegO(Option<String> ffmpegPath) {
        return ffmpegPath.map(this::withFFmpeg)
                .getOrElse(this);
    }

    public FFPaths withFFmpeg(String ffmpegPath) {
        return new FFPaths(new File2(ffmpegPath), ffprobe);
    }

    public FFPaths withFFprobeO(Option<String> ffprobePath) {
        return ffprobePath.map(this::withFFprobe)
                .getOrElse(this);
    }

    public FFPaths withFFprobe(String ffprobePath) {
        return new FFPaths(ffmpeg, new File2(ffprobePath));
    }

    public File2 getFFmpeg() {
        return ffmpeg;
    }

    public File2 getFFprobe() {
        return ffprobe;
    }

    public static void validatePath(String name, String path) {
        validatePath(name, new File2(path));
    }

    private static void validatePath(String name, File2 path) {
        Validate.isTrue(path.exists(), String.format("Specified %s path = %s doesn't exist", name, path));
    }
}
