package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import java.io.InputStream;
import java.util.function.Consumer;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFmpegCommand extends DefaultObject {
    final Option<String> execO;

    final ProcessCommand inParams;

    final FFmpegSource source;

    final ProcessCommand outParams;

    final FFmpegOutput out;

    final Option<MediaTime> durationO;

    public FFmpegCommand(Option<String> execO, ProcessCommand inParams, FFmpegSource source, ProcessCommand outParams,
            FFmpegOutput out, Option<MediaTime> durationO)
    {
        this.execO = execO;
        this.inParams = inParams;
        this.source = source;
        this.outParams = outParams;
        this.out = out;
        this.durationO = durationO;
    }

    public FFmpegCommand withDuration(MediaTime duration) {
        return new FFmpegCommand(execO, inParams, source, outParams, out, Option.of(duration));
    }

    public FFmpegSource getSource() {
        return source;
    }

    public FFmpegOutput getTarget() {
        return out;
    }

    public Option<Consumer<InputStream>> getPipeConsumerO() {
        return getTarget()
                .getPipeConsumerO();
    }

    public Option<MediaTime> getDurationO() {
        return durationO;
    }

    public ProcessBuilder toProcessBuilder() {
        return toProcessCommand()
                .toProcessBuilder();
    }

    public ListF<String> toStringList() {
        return toProcessCommand()
                .toStringList();
    }

    public ProcessCommand toProcessCommand() {
        return new ProcessCommandBuilder()
                .addO(execO)
                .add(inParams)
                .add("-i", source.getUriStr())
                .add(outParams)
                .add(out.toString())
                .build();
    }

    public FFmpegCommandBuilder toBuilder() {
        return new FFmpegCommandBuilder(this);
    }
}
