package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFmpegCommandBuilderTest {
    @Test
    public void test() {
        FFmpegCommandBuilder builder = new FFmpegCommandBuilder(
                FFmpegSource.cons(new UriBuilder("http://localhost/source").build()),
                FFmpegOutput.uri("http://localhost/target")
        );
        Assert.assertListsEqual(
                Cf.list(
                        "/bin/ffmpeg",
                        "-in_param1", "123",
                        "-in_param2",
                        "-in_param3",
                        "-in_param5", "value5",
                        "-in_param7", "value7",
                        "-in_param10",
                        "-in_param1808els", "value1808els",
                        "-in_param11",
                        "-in_param12", "value12",
                        "-in_param16", "value16",
                        "-in_param17",
                        "-in_end",
                        "-i", "http://localhost/source",
                        "-out_param1", "321",
                        "-out_param2",
                        "-out_param3",
                        "-out_param5", "value5",
                        "-out_param7", "value7",
                        "-out_param10",
                        "-out_param1808else", "value1808els",
                        "-out_param11",
                        "-out_param12", "value12",
                        "-out_param16", "value16",
                        "-out_param17",
                        "-out_end",
                        "http://localhost/target"
                ),
                builder.exec("/bin/ffmpeg")
                        .in("-in_param1", 123)
                        .in("-in_param2")
                        .inIf("-in_param3", true)
                        .inIf("-in_param4", false)
                        .inIf("-in_param5", "value5", true)
                        .inIf("-in_param6", "value6", false)
                        .inIf("-in_param7", "value7", true)
                        .elseIn("-in_param8")
                        .inIf("-in_param9", "value9", false)
                        .elseIn("-in_param10")
                        .inIf("-in_param1808", "value1808", false)
                        .elseIn("-in_param1808els", "value1808els")
                        .applyIf(b -> {
                            b.in("-in_param11");
                            b.in("-in_param12", "value12");
                        }, true)
                        .applyIf(b -> {
                            b.in("-in_param13");
                            b.in("-in_param14", "value14");
                        }, false)
                        .inO("-in_param15", Option.empty())
                        .inO("-in_param16", Option.of("value16"))
                        .inO(Option.empty())
                        .inO(Option.of("-in_param17"))
                        .out("-out_param1", 321)
                        .out("-out_param2")
                        .outIf("-out_param3", true)
                        .outIf("-out_param4", false)
                        .outIf("-out_param5", "value5", true)
                        .outIf("-out_param6", "value6", false)
                        .outIf("-out_param7", "value7", true)
                        .elseOut("-out_param8")
                        .outIf("-out_param9", "value9", false)
                        .elseOut("-out_param10")
                        .outIf("-out_param1808", "value1808", false)
                        .elseOut("-out_param1808else", "value1808els")
                        .applyIf(b -> {
                            b.out("-out_param11");
                            b.out("-out_param12", "value12");
                        }, true)
                        .applyIf(b -> {
                            b.out("-out_param13");
                            b.out("-out_param14", "value14");
                        }, false)
                        .outO("-out_param15", Option.empty())
                        .outO("-out_param16", Option.of("value16"))
                        .outO(Option.empty())
                        .outO(Option.of("-out_param17"))
                        .in("-in_end")
                        .out("-out_end")
                        .toStringList()
        );
    }
}
