package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import java.io.InputStream;
import java.util.function.Consumer;

import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFmpegOutputTest {
    @Test
    public void uri() {
        Assert.equals(
                "http://ya.ru/",
                FFmpegOutput.uri("http://ya.ru/")
                        .toString()
        );
    }

    @Test
    public void file() {
        Assert.equals(
                "/path/to/some/file.mkv",
                FFmpegOutput.path(new File2("/path/to/some/file.mkv"))
                        .toString()
        );
    }

    @Test
    public void pipe() {
        Consumer<InputStream> consumer = inputStream -> { /* do nothing */ };
        FFmpegOutput output = FFmpegOutput.pipe(consumer);
        Assert.equals("pipe", output.toString());
        Assert.some(consumer, output.getPipeConsumerO());
    }

    @Test
    public void raw() {
        Runnable closer = Mockito.mock(Runnable.class);
        FFmpegOutput output = FFmpegOutput.raw("raw value", closer);
        Assert.equals("raw value", output.toString());

        output.close();
        Mockito.verify(closer, Mockito.times(1))
                .run();
    }
}
