package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import lombok.experimental.NonFinal;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.config.FFmpegVersions;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Value
@NonFinal
@AllArgsConstructor
@Builder(toBuilder = true)
public class FFmpegParams {
    private static final String DEFAULT_FFMPEG_VERSION = FFmpegVersions.VER_4_1;

    public static final FFmpegParams DEFAULT = new FFmpegParams(
            DEFAULT_FFMPEG_VERSION, Duration.standardDays(100), Duration.standardMinutes(30), Duration.ZERO,
            Option.empty(), Option.empty(), false
    );

    String ffmpegVersion;

    Duration transcodingTimeout;

    Duration encodingStartTimeout;

    Duration minLeftOverDuration;

    Option<Integer> maxProcCountO;

    Option<Double> maxCpuLoadO;

    boolean outputLoggingEnabled;

    public FFmpegParams(Duration transcodingTimeout, Duration encodingStartTimeout, Duration minLeftOverDuration,
            int maxProcCount)
    {
        this(DEFAULT_FFMPEG_VERSION, transcodingTimeout, encodingStartTimeout, minLeftOverDuration,
                Option.of(maxProcCount), Option.empty(), false);
    }
}
