package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import java.net.URI;
import java.util.UUID;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFmpegSource extends DefaultObject {
    private final URI uri;

    public final UUID sessionId;

    public final String key;

    private FFmpegSource(URI uri, UUID sessionId, String key) {
        this.uri = uri;
        this.sessionId = sessionId;
        this.key = key;
    }

    public static FFmpegSource cons(URI uri) {
        return cons(sessionId -> uri);
    }

    public static FFmpegSource cons(Function<UUID, URI> uriF) {
        return cons(uriF, Option.empty());
    }

    public static FFmpegSource cons(Function<UUID, URI> uriF, Option<String> key) {
        UUID sessionId = UUID.randomUUID();
        URI uri = uriF.apply(sessionId);
        return new FFmpegSource(uri, sessionId, key.getOrElse(uri.toASCIIString()));
    }

    public String getUriStr() {
        return uri.toASCIIString();
    }
}
