package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import java.util.Collections;
import java.util.UUID;
import java.util.WeakHashMap;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFmpegSourceExceptionRegistry {
    public static final FFmpegSourceExceptionRegistry INSTANCE = new FFmpegSourceExceptionRegistry();

    private final MapF<UUID, Throwable> sessionToThrowable = Cf.x(Collections.synchronizedMap(new WeakHashMap<>()));

    private FFmpegSourceExceptionRegistry() {

    }

    public Option<Throwable> getExceptionO(FFmpegSource source) {
        return sessionToThrowable.getO(source.sessionId);
    }

    public void setException(UUID sessionId, Throwable exception) {
        sessionToThrowable.put(sessionId, exception);
    }
}
