package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import org.joda.time.Duration;
import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 * @author Dmitriy Amelin (lemeh)
 */
public class FFmpegStatsTest {
    @Test
    public void parse() {
        Assert.some(
                new FFmpegStats(609, 174, new Duration(26088), 0.5, 3494 * 1024),
                parse("frame=  609 fps=174 q=5.5 size=    3494kB time=00:00:26.88 bitrate=1064.8kbits/s dup=6 drop=0 speed=0.5x")
        );

        Assert.some(
                new FFmpegStats(609, 171.2, new Duration(26088), 1.62, 3494 * 1024),
                parse("frame=  609 fps=171.2 q=5.5 size=    3494kB time=00:00:26.88 bitrate=1064.8kbits/s dup=6 drop=0 speed=1.62x")
        );

        Assert.some(
                new FFmpegStats(609, 171.2, new Duration((30 * 60 * 60 + 26) * 1000 + 88), 3.5, 3494 * 1024),
                parse("frame=  609 fps=171.2 q=5.5 size=    3494kB time=30:00:26.88 bitrate=1064.8kbits/s dup=6 drop=0 speed=3.5x")
        );

        Assert.some(
                new FFmpegStats(2079, 91.0, new Duration(86069), 0.1, Option.empty()),
                parse("frame= 2079 fps= 91 q=24.0 size=N/A time=00:01:26.69 bitrate=N/A speed=3.81x dup=6 drop=0 speed=0.1x")
        );
    }

    private static Option<FFmpegStats> parse(String line) {
        return FFmpegStats.parseStderr(line);
    }
}
