package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import org.junit.Test;

import ru.yandex.chemodan.videostreaming.framework.config.FFmpegVersions;
import ru.yandex.misc.io.InputStreamX;
import ru.yandex.misc.io.IoUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFmpegTest {
    @Test
    public void readDataFromStdout() throws InterruptedException, TimeoutException, ExecutionException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompletableFuture<Void> dataWritten = new CompletableFuture<>();
        FFmpegCommand command = new FFmpegCommandBuilder(
                FFmpegSource.cons(URI.create("http://localhost/src")),
                FFmpegOutput.pipe(inputStream -> {
                    IoUtils.copy(new InputStreamX(inputStream), baos);
                    dataWritten.complete(null);
                })
        ).build();
        FFmpegVersions ffmpegVersions = FFmpegVersions.single(
                FFmpegParams.DEFAULT.getFfmpegVersion(), "/bin/echo", "/bin/echo");
        FFmpeg.Session session =
                new FFmpeg(ffmpegVersions, FFmpegParams.DEFAULT, new FFmpegExecutor(new TranscodingInventory(null, null, null)))
                        .execute(command);

        session.waitForProcess()
                .waitFor();
        dataWritten.get(5, TimeUnit.SECONDS);

        Assert.equals("-hide_banner -i http://localhost/src pipe\n", new String(baos.toByteArray()));
    }
}
