package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import org.joda.time.Period;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;

/**
 * @author Dmitriy Amelin (lemeh)
 * @see <a href="https://ffmpeg.org/ffmpeg-utils.html#time-duration-syntax>Time duration</a>
 */
public class FFmpegTimeDurationUtil {
    private static final PeriodFormatter formatter = new PeriodFormatterBuilder()
            .minimumPrintedDigits(2)
            .appendHours()
            .appendSeparator(":")
            .printZeroAlways()
            .appendMinutes()
            .appendSeparator(":")
            .appendSeconds()
            .printZeroNever()
            .minimumPrintedDigits(3)
            .appendSeparator(".")
            .appendMillis()
            .toFormatter();

    private static final PeriodFormatter secondsFormatter = new PeriodFormatterBuilder()
            .printZeroAlways()
            .appendSeconds()
            .printZeroNever()
            .minimumPrintedDigits(3)
            .appendSeparator(".")
            .appendMillis()
            .toFormatter();

    public static String format(MediaTime duration) {
        return formatter.print(duration.toPeriod());
    }

    public static String formatInSeconds(MediaTime duration) {
        Period period = duration.toPeriod();
        return secondsFormatter.print(
                period.toStandardSeconds()
                        .toPeriod()
                        .plusMillis(period.getMillis())
        );
    }

    public static MediaTime parse(String value) {
        return MediaTime.fromPeriod(Period.parse(value, formatter));
    }

    private FFmpegTimeDurationUtil() {}
}
