package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import org.junit.Test;

import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFmpegTimeDurationUtilTest {
    @Test
    public void formatSeconds() {
        Assert.equals(
                "01:02:03",
                FFmpegTimeDurationUtil.format(MediaTime.seconds(62 * 60 + 3))
        );
    }

    @Test
    public void formatSingleDigitMillis() {
        Assert.equals(
                "00:00.020",
                FFmpegTimeDurationUtil.format(
                        MediaTime.millis(20)
                )
        );
    }

    @Test
    public void formatInSeconds() {
        Assert.equals(
                "165.001",
                FFmpegTimeDurationUtil.formatInSeconds(
                        MediaTime.seconds(165)
                                .plus(MediaTime.millis(1))
                )
        );
    }

    @Test
    public void formatZeroInSeconds() {
        Assert.equals("0", FFmpegTimeDurationUtil.formatInSeconds(MediaTime.ZERO));
    }

    @Test
    public void parse() {
        Assert.equals(
                MediaTime.millis(26 * 1000 + 88),
                FFmpegTimeDurationUtil.parse("00:00:26.88")
        );
    }
}
