package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ProcessCommand extends DefaultObject {
    final ListF<Arg> args;

    ProcessCommand(ListF<Arg> args) {
        this.args = args;
    }

    public ListF<String> toStringList() {
        return args.map(Arg::toList)
                .flatten();
    }

    public ProcessBuilder toProcessBuilder() {
        return new ProcessBuilder(toStringList());
    }

    @Override
    public String toString() {
        return StringUtils.join(toStringList(), " ");
    }

    public ProcessCommandBuilder toBuilder() {
        return new ProcessCommandBuilder(Cf.toArrayList(args));
    }

    static class Arg extends DefaultObject {
        final String key;

        final Option<Object> valueO;

        Arg(String key) {
            this(key, Option.empty());
        }

        Arg(String key, Object value) {
            this(key, Option.of(value));
        }

        private Arg(String key, Option<Object> valueO) {
            this.key = key;
            this.valueO = valueO;
        }

        ListF<String> toList() {
            return Cf.list(key)
                    .plus(valueO.map(Object::toString));
        }
    }
}
