package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import java.util.Collection;
import java.util.function.Consumer;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectorsF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ProcessCommand.Arg;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@SuppressWarnings({"unused", "SameParameterValue"})
public class ProcessCommandBuilder extends DefaultObject {
    private final ListF<Arg> args;

    public ProcessCommandBuilder() {
        this(Cf.arrayList());
    }

    public ProcessCommandBuilder(ListF<Arg> args) {
        this.args = args;
    }

    public ProcessCommandBuilder.WithCondition addIf(String key, Object value, boolean condition) {
        return addIf(new Arg(key, value), condition);
    }

    public ProcessCommandBuilder.WithCondition addIf(String key, boolean condition) {
        return runIf(() -> add(key), condition);
    }

    public ProcessCommandBuilder.WithCondition addIf(Arg arg, boolean condition) {
        return runIf(() -> add(arg), condition);
    }

    public ProcessCommandBuilder.WithCondition applyIf(Consumer<ProcessCommandBuilder> consumer, boolean condition) {
        return runIf(() -> consumer.accept(this), condition);
    }

    private ProcessCommandBuilder.WithCondition runIf(Runnable runnable, boolean condition) {
        if (condition) {
            runnable.run();
        }
        return new WithCondition(args, condition);
    }

    public ProcessCommandBuilder addO(Option<?> valueO) {
        if (!valueO.isPresent()) {
            return this;
        }

        Object value = valueO.get();
        if (value instanceof Collection) {
            return add(((Collection<?>) value).stream()
                    .map(Object::toString)
                    .collect(CollectorsF.toList())
            );
        } else {
            return add(value.toString());
        }
    }

    public ProcessCommandBuilder addO(String key, Option<?> value) {
        return value.isPresent() ? add(key, value.get()) : this;
    }

    public ProcessCommandBuilder add(String key) {
        return add(new Arg(key));
    }

    public ProcessCommandBuilder add(String key, Object value) {
        return add(new Arg(key, value));
    }

    public ProcessCommandBuilder add(Arg arg) {
        args.add(arg);
        return this;
    }

    public ProcessCommandBuilder add(ListF<String> args) {
        return addArgs(args.map(Arg::new));
    }

    public ProcessCommandBuilder add(ProcessCommandBuilder another) {
        return addArgs(another.args);
    }

    public ProcessCommandBuilder add(ProcessCommand command) {
        return addArgs(command.args);
    }

    private ProcessCommandBuilder addArgs(ListF<Arg> args) {
        this.args.addAll(args);
        return this;
    }

    @Override
    public String toString() {
        return StringUtils.join(build().toStringList(), " ");
    }

    public ProcessCommand build() {
        return new ProcessCommand(args.unmodifiable());
    }

    public static class WithCondition extends ProcessCommandBuilder {
        private final boolean condition;

        public WithCondition(ListF<Arg> args, boolean condition) {
            super(args);
            this.condition = condition;
        }

        public ProcessCommandBuilder orElse(String key) {
            if (!condition) {
                add(key);
            }
            return this;
        }

        public boolean getCondition() {
            return condition;
        }
    }
}
