package ru.yandex.chemodan.videostreaming.framework.ffmpeg;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ProcessCommandBuilderTest {
    @Test
    public void testAddIfTrue() {
        assertResultEquals(
                "key1 value1 value2",
                new ProcessCommandBuilder()
                        .addIf("key1", "value1", true)
                        .addIf("value2", true)
        );
    }

    @Test
    public void testAddIfFalse() {
        assertResultEquals(
                "",
                new ProcessCommandBuilder()
                        .addIf("key", "value", false)
                        .addIf("value", false)
        );
    }

    @Test
    public void testAddOptionPresent() {
        assertResultEquals(
                "key value",
                new ProcessCommandBuilder()
                        .addO("key", Option.of("value"))
        );
    }

    @Test
    public void testAddOptionEmpty() {
        assertResultEquals(
                "",
                new ProcessCommandBuilder()
                        .addO("key", Option.empty())
        );
    }

    @Test
    public void testAdd() {
        assertResultEquals(
                "key1 value1 value2 key3 value3",
                new ProcessCommandBuilder()
                        .add("key1", "value1")
                        .add("value2")
                        .add("key3", "value3")
        );
    }

    @Test
    public void testOrElseWhenConditionIsTrue() {
        assertResultEquals("key",
                new ProcessCommandBuilder()
                        .addIf("key", true)
                        .orElse("another key")
        );
    }

    @Test
    public void testOrElseWhenConditionIsFalse() {
        assertResultEquals("another key",
                new ProcessCommandBuilder()
                        .addIf("key", false)
                        .orElse("another key")
        );
    }

    @Test
    public void testOptionOfList() {
        assertResultEquals("key1 key2",
                new ProcessCommandBuilder()
                        .addO(Option.of(
                                Cf.list("key1", "key2")
                        ))
        );
    }

    @Test
    public void testOptionOfString() {
        assertResultEquals("key",
                new ProcessCommandBuilder()
                        .addO(Option.of("key"))
        );
    }

    private static void assertResultEquals(String expected, ProcessCommandBuilder builder) {
        Assert.equals(expected, builder.toString());
    }
}
