package ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe;

import ru.yandex.chemodan.util.bender.UnderscoreNamesBenderConfiguration;
import ru.yandex.chemodan.videostreaming.framework.media.units.AspectRatio;
import ru.yandex.chemodan.videostreaming.framework.media.units.FrameRate;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.parse.BenderParser;

/**
 * @author Dmitriy Amelin (lemeh)
 */
class BenderUtil {
    private static final BenderConfiguration benderConfig = UnderscoreNamesBenderConfiguration.cons(
            BenderConfiguration.defaultSettings(),
            CustomMarshallerUnmarshallerFactoryBuilder.cons()
                    .add(FrameRate.class, FrameRate.unmarshaller)
                    .add(AspectRatio.class, AspectRatio.unmarshaller)
                    .add(MediaTime.class, MediaTime.unmarshaller)
                    .build()
    );

    static <T> BenderParser<T> consParser(Class<T> clazz) {
        return Bender.cons(clazz, benderConfig)
                .getParser();
    }
}
