package ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe;

import lombok.Builder;
import lombok.NonNull;
import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.media.units.BitRate;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Value
@Builder(builderClassName = "Builder", toBuilder = true)
@BenderBindAllFields
public class FFprobeFormat {
    @NonNull
    @BenderPart(name = "format_name")
    String name;

    @NonNull
    @BenderDefaultValue("0.000000")
    MediaTime startTime;

    @NonNull
    @BenderDefaultValue("0.000000")
    MediaTime duration;

    @NonNull
    Option<BitRate> bitRate;

    int probeScore;

    @NonNull
    Option<Tags> tags;

    @Value
    @BenderBindAllFields
    public static class Tags {
        Option<String> creationTime;
    }

    public static class Builder {
        @SuppressWarnings("unused") // used to set default value
        MediaTime startTime = MediaTime.ZERO;

        Option<BitRate> bitRate = Option.empty();

        Option<Tags> tags = Option.empty();

        public Builder bitRate(BitRate bitRate) {
            return bitRate(Option.of(bitRate));
        }

        public Builder bitRate(Option<BitRate> bitRate) {
            this.bitRate = bitRate;
            return this;
        }

        public Builder tags(Tags tags) {
            return tags(Option.of(tags));
        }

        public Builder tags(Option<Tags> tags) {
            this.tags = tags;
            return this;
        }
    }
}
