package ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe;

import lombok.AllArgsConstructor;
import lombok.Value;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.bender.UnderscoreNamesBenderConfiguration;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.lang.CharsetUtils;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Value
@AllArgsConstructor
@BenderBindAllFields
public class FFprobeInfo {
    private static final BenderParserSerializer<FFprobeInfo> parserSerializer =
            Bender.cons(FFprobeInfo.class, UnderscoreNamesBenderConfiguration.cons(
                    BenderConfiguration.defaultSettings(),
                    CustomMarshallerUnmarshallerFactoryBuilder.cons()
                            .add(FFprobeStream.class, FFprobeStream.unmarshaller)
                            .add(MediaTime.class, MediaTime.unmarshaller)
                            .build()
                    )
            );

    FFprobeFormat format;

    ListF<FFprobeStream> streams;

    public FFprobeInfo(FFprobeFormat format, FFprobeStream... streams) {
        this(format, Cf.list(streams));
    }

    public static FFprobeInfo parse(byte[] json) {
        return parse(new String(json, CharsetUtils.UTF8_CHARSET));
    }

    public static FFprobeInfo parse(String json) {
        return parserSerializer.getParser()
                .parseJson(fixJson(json));
    }

    private static String fixJson(String json) {
        // workaround for ffprobe bug
        return StringUtils.lines(json)
                .filter(line -> !line.startsWith("insert cmd") && !line.startsWith("event_id"))
                .mkString("\n");
    }

    public ListF<FFprobeStream.Video> getVideoStreams() {
        return streams.filterByType(FFprobeStream.Video.class);
    }

    public ListF<FFprobeStream.Audio> getAudioStreams() {
        return streams.filterByType(FFprobeStream.Audio.class);
    }

    public Option<FFprobeStream.Video> getVideoStreamO() {
        return getVideoStreams()
                .firstO();
    }
}
