package ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe;

import ru.yandex.chemodan.videostreaming.framework.media.units.FrameRate;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.chemodan.videostreaming.framework.media.units.SampleFrequency;
import ru.yandex.misc.image.Dimension;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFprobeSharedFixtures {
    public static final FFprobeStream.Video VIDEO_1080P_24FPS =
            FFprobeStream.Video.builder()
                    .index(1)
                    .codecName("h264")
                    .dimension(new Dimension(1920, 1080))
                    .rFrameRate(new FrameRate(24))
                    .avgFrameRate(new FrameRate(24))
                    .build();

    public static final FFprobeStream.Audio AUDIO_STEREO_44KHZ =
            FFprobeStream.Audio.builder()
                    .index(2)
                    .codecName("ac3")
                    .sampleRate(new SampleFrequency(44000))
                    .channels(2)
                    .channelLayout("stereo")
                    .build();

    public static final FFprobeFormat FORMAT_MKV_1HR =
            FFprobeFormat.builder()
                    .name("matroska,webm")
                    .duration(MediaTime.minutes(60))
                    .probeScore(100)
                    .build();

    public static final FFprobeInfo INFO_1HR_1080P_STEREO =
            new FFprobeInfo(FORMAT_MKV_1HR, VIDEO_1080P_24FPS, AUDIO_STEREO_44KHZ);
}
