package ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.analysis;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeInfo;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeStream;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.io.file.File2;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFprobeStartTimeAnalyzer {
    private static final ListF<String> SKIP_FORMATS = Cf.list(
            "mpeg", "flv"
    );

    public void process(Tuple2<FFprobeInfo, File2> infoAndFile) {
        FFprobeInfo info = infoAndFile.get1();
        info.getVideoStreamO()
                .ifPresent(video ->
                        info.getAudioStreams()
                                .firstO()
                                .ifPresent(audio -> process(infoAndFile.get1(), infoAndFile.get2(), video, audio))
                );
    }

    private void process(FFprobeInfo info, File2 file, FFprobeStream.Video video, FFprobeStream.Audio audio) {
        if (SKIP_FORMATS.containsTs(info.getFormat().getName())) {
            return;
        }

        video.getDuration()
                .ifPresent(videoStart ->
                        audio.getDuration()
                                .ifPresent(audioStart -> process(file, videoStart, audioStart)))
        ;
    }

    private void process(File2 file, MediaTime videoStart, MediaTime audioStart) {
        if ((audioStart.getMillis() - videoStart.getMillis()) > 5000) {
            System.out.println(videoStart + " " + audioStart + " " + file);
        }
    }

    public static void main(String[] args) {
        FFprobeStartTimeAnalyzer analyzer = new FFprobeStartTimeAnalyzer();
        new MultiThreadedAnalyzer(analyzer::process, 30)
                .run();
    }
}
