package ru.yandex.chemodan.videostreaming.framework.hls;

import org.junit.Test;

import ru.yandex.chemodan.videostreaming.framework.media.units.BitRate;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.test.Assert;

public class BitRateUtilsTest {
    @Test
    public void testLtLowDim() {
        Assert.equals(BitRate.fromKbps(384), calcBitRate(160, 120));
    }

    @Test
    public void testEqLowDim() {
        Assert.equals(BitRate.fromKbps(384), calcBitRate(426, 240));
    }

    @Test
    public void testGtLowDim() {
        Assert.equals(BitRate.fromKbps(777), calcBitRate(540, 320));
    }

    @Test
    public void testEqMinHq() {
        Assert.equals(BitRate.fromKbps(1152), calcBitRate(600, 400));
    }

    @Test
    public void testGtMinHq() {
        Assert.equals(BitRate.fromKbps(1543), calcBitRate(640, 480));
    }

    @Test
    public void testEqMaxHq() {
        Assert.equals(BitRate.fromKbps(5120), calcBitRate(1280, 720));
    }

    @Test
    public void testGtMaxHq() {
        Assert.equals(BitRate.fromKbps(11826), calcBitRate(1920, 1080));
    }

    @Test
    public void testGreaterDimMatchesGreaterBitRate() {
        Assert.gt(
                calcBitRate(450, 260),
                calcBitRate(440, 250)
        );
    }

    private static BitRate calcBitRate(int width, int height) {
        return BitrateUtils.videoBitRateForDimension(new Dimension(width, height));
    }
}
