package ru.yandex.chemodan.videostreaming.framework.hls;

import java.math.BigDecimal;
import java.math.RoundingMode;

import org.joda.time.DateTimeConstants;

import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DurationUtil {
    private DurationUtil() {}

    public static BigDecimal toSecondsWith2DecimalPlaces(MediaTime duration) {
        return BigDecimal.valueOf(duration.getMillis())
                .divide(HlsSegmentMeta.MILLIS_PER_SECOND, 2, RoundingMode.HALF_DOWN);
    }

    public static int toSecondsCeil(MediaTime duration) {
        return (int) Math.ceil(toSecondsDouble(duration));
    }

    public static double toSecondsDouble(MediaTime duration) {
        return (double) duration.getMillis() / DateTimeConstants.MILLIS_PER_SECOND;
    }
}
