package ru.yandex.chemodan.videostreaming.framework.hls;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.commune.dynproperties.DynamicPropertyWatcher;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ForceFFmpeg3ForFormats implements DynamicPropertyWatcher<String> {
    private static final String DELIMITER = "---";

    private static final DynamicProperty<String> forceFFmpeg3ForFormats =
            DynamicProperty.cons("force-ffmpeg3-for-formats", "mpegts");

    private volatile ListF<String> formats = Cf.list();

    public ForceFFmpeg3ForFormats(DynamicPropertyManager manager) {
        manager.addStaticFields(getClass());
        manager.registerAndFireWatcher(forceFFmpeg3ForFormats, this);
    }

    @Override
    public void updated(String value) {
        formats = Cf.list(value.split(DELIMITER));
    }

    public boolean contains(String format) {
        return formats.containsTs(format);
    }
}
