package ru.yandex.chemodan.videostreaming.framework.hls;

import lombok.Value;

import ru.yandex.chemodan.videostreaming.framework.media.units.Fraction;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.chemodan.videostreaming.framework.media.units.SampleFrequency;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Value
public class FrameSegment {
    Fraction frmLen;

    Fraction segLen;

    public FrameSegment(Fraction frmLen, Fraction segLen) {
        this.frmLen = frmLen;
        this.segLen = segLen;
    }

    public static FrameSegment fromSampleFrequencyAndSegDuration(SampleFrequency sampleFrequency, MediaTime segLen) {
        return fromFrmLenAndSegDuration(new Fraction(1024, sampleFrequency.getValue()), segLen);
    }

    public static FrameSegment fromFrmLenAndSegDuration(Fraction frmLen, MediaTime segLen) {
        return new FrameSegment(
                frmLen.multiply(MediaTime.MICROS_PER_SECOND),
                new Fraction(segLen.getMicros(), 1)
        );
    }

    public Section calcSection(int segNum) {
        Fraction start = calcFrameOffsetBeforeSegmentOffset(segNum);
        Fraction end = calcFrameOffsetBeforeSegmentOffset(segNum + 1);
        return new Section(start, end.minus(start));
    }

    private Fraction calcFrameOffsetBeforeSegmentOffset(int segNum) {
        Fraction segTime = segLen.multiply(segNum);
        return frmLen.multiply(segTime.divide(frmLen).floor());
    }

    public MediaTime getFramesDuration(int frmCnt) {
        return new MediaTime(frmLen.multiply(frmCnt).floor());
    }

    public static class Section extends DefaultObject {
        final Fraction offset;

        final Fraction duration;

        public Section(Fraction offset, Fraction duration) {
            this.offset = offset;
            this.duration = duration;
        }

        public MediaTime getOffset() {
            return new MediaTime(offset.floor());
        }

        public MediaTime getDuration() {
            return new MediaTime(duration.floor());
        }
    }
}
