package ru.yandex.chemodan.videostreaming.framework.hls;

import java.net.URI;
import java.util.UUID;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegSource;
import ru.yandex.chemodan.videostreaming.framework.hls.sourcemeta.SourceMetaWithKey;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface HlsFFmpegSourceProvider<T> {
    URI getUri(T sourceMeta, UUID sessionId);

    default FFmpegSource get(T sourceMeta) {
        //noinspection ConstantConditions
        return FFmpegSource.cons(sessionId -> getUri(sourceMeta, sessionId),
                Option.when(
                        (sourceMeta instanceof SourceMetaWithKey),
                        () -> ((SourceMetaWithKey) sourceMeta).getKey().toString()
                )
        );
    }
}
