package ru.yandex.chemodan.videostreaming.framework.hls;

import java.util.function.Consumer;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegParams;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.HlsFFmpegCommandParams;
import ru.yandex.chemodan.videostreaming.framework.hls.videoinfo.StreamingResourceParams;
import ru.yandex.chemodan.videostreaming.framework.hls.videoinfo.VideoInfoParams;
import ru.yandex.chemodan.videostreaming.framework.util.threadlocal.TlOverrideDynamicProxy;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsParams {
    private final TlOverrideDynamicProxy<StreamingParams> streamingParams;

    private final TlOverrideDynamicProxy<VideoInfoParams> videoInfoParams;

    private final TlOverrideDynamicProxy<FFmpegParams> ffmpegParams;

    private final TlOverrideDynamicProxy<HlsFFmpegCommandParams> ffmpegCommandParams;

    private final TlOverrideDynamicProxy<StreamingResourceParams> streamingResourceParams;

    public HlsParams(StreamingParams streamingParams, VideoInfoParams videoInfoParams,
            FFmpegParams ffmpegParams, HlsFFmpegCommandParams ffmpegCommandParams,
            StreamingResourceParams streamingResourceParams)
    {
        this.streamingParams = new TlOverrideDynamicProxy<>(streamingParams, StreamingParams.class);
        this.videoInfoParams = new TlOverrideDynamicProxy<>(videoInfoParams, VideoInfoParams.class);
        this.ffmpegParams = new TlOverrideDynamicProxy<>(ffmpegParams, FFmpegParams.class);
        this.ffmpegCommandParams = new TlOverrideDynamicProxy<>(ffmpegCommandParams, HlsFFmpegCommandParams.class);
        this.streamingResourceParams = new TlOverrideDynamicProxy<>(streamingResourceParams,
                StreamingResourceParams.class);
    }

    public StreamingParams getStreamingParams() {
        return streamingParams.getProxy();
    }

    public VideoInfoParams getVideoInfoParams() {
        return videoInfoParams.getProxy();
    }

    public FFmpegParams getFFmpegParams() {
        return ffmpegParams.getProxy();
    }

    public HlsFFmpegCommandParams getFFmpegCommandParams() {
        return ffmpegCommandParams.getProxy();
    }

    public StreamingResourceParams getStreamingResourceParams() {
        return streamingResourceParams.getProxy();
    }

    public Overridable consOverridable() {
        return new Overridable();
    }

    @SuppressWarnings("UnusedReturnValue")
    public class Overridable extends DefaultObject {
        private StreamingParams.StreamingParamsBuilder streamingParams =
                HlsParams.this.streamingParams.getProxy().toBuilder();

        private VideoInfoParams.VideoInfoParamsBuilder videoInfoParams =
                HlsParams.this.videoInfoParams.getProxy().toBuilder();

        private FFmpegParams.FFmpegParamsBuilder ffmpegParams =
                HlsParams.this.ffmpegParams.getProxy().toBuilder();

        private HlsFFmpegCommandParams.HlsFFmpegCommandParamsBuilder ffmpegCommandParams =
                HlsParams.this.ffmpegCommandParams.getProxy().toBuilder();

        private StreamingResourceParams.StreamingResourceParamsBuilder streamingResourceParams =
                HlsParams.this.streamingResourceParams.getProxy().toBuilder();

        public Overridable override(Overrider... overriders) {
            Cf.list(overriders)
                    .forEach(overrider -> overrider.override(this));
            return this;
        }

        public Overridable withStreamingParams(Consumer<StreamingParams.StreamingParamsBuilder> buildF) {
            return buildAndGetSelf(streamingParams, buildF);
        }

        public Overridable withVideoInfoParams(Consumer<VideoInfoParams.VideoInfoParamsBuilder> buildF) {
            return buildAndGetSelf(videoInfoParams, buildF);
        }

        public Overridable withFFmpegParams(Consumer<FFmpegParams.FFmpegParamsBuilder> buildF) {
            return buildAndGetSelf(ffmpegParams, buildF);
        }

        public Overridable withStreamingResourceParams(Consumer<StreamingResourceParams.StreamingResourceParamsBuilder>
                buildF)
        {
            return buildAndGetSelf(streamingResourceParams, buildF);
        }

        @SuppressWarnings("UnusedReturnValue")
        public Overridable withFFmpegCommandParams(
                Consumer<HlsFFmpegCommandParams.HlsFFmpegCommandParamsBuilder> buildF)
        {
            return buildAndGetSelf(ffmpegCommandParams, buildF);
        }

        public void run(Runnable runnable) {
            HlsParams.this.run(this, runnable);
        }

        private <T> Overridable buildAndGetSelf(T builder, Consumer<T> buildF) {
            buildF.accept(builder);
            return this;
        }
    }

    private void run(Overridable o, Runnable runnable) {
        videoInfoParams.runWith(o.videoInfoParams.build(),
                () -> streamingParams.runWith(o.streamingParams.build(),
                        () -> ffmpegParams.runWith(o.ffmpegParams.build(),
                                () -> ffmpegCommandParams.runWith(o.ffmpegCommandParams.build(),
                                        () -> streamingResourceParams.runWith(o.streamingResourceParams.build(),
                                                runnable)
                                )
                        )
                )
        );
    }

    public interface Overrider {
        void override(Overridable overridable);
    }
}
