package ru.yandex.chemodan.videostreaming.framework.hls;

import java.util.concurrent.atomic.AtomicBoolean;

import org.joda.time.Duration;
import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegParams;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.HlsFFmpegCommandParams;
import ru.yandex.chemodan.videostreaming.framework.hls.videoinfo.StreamingResourceParams;
import ru.yandex.chemodan.videostreaming.framework.hls.videoinfo.VideoInfoParams;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsParamsTest {
    @Test
    public void overrideable() {
        AtomicBoolean executed = new AtomicBoolean(false);
        HlsParams sut = consSut();
        sut.consOverridable()
                .withStreamingParams(builder -> builder.segmentDuration(MediaTime.seconds(6))
                        .initPrefetchSize(5)
                        .maxPrefetchSize(10)
                        .maxCacheWait(Duration.standardMinutes(1))
                )
                .withVideoInfoParams(builder -> builder.cacheDisabled(true))
                .withFFmpegParams(builder -> builder.transcodingTimeout(Duration.standardMinutes(1))
                        .encodingStartTimeout(Duration.standardSeconds(10))
                        .minLeftOverDuration(Duration.standardSeconds(2))
                        .maxProcCountO(Option.of(12))
                )
                .withFFmpegCommandParams(builder -> builder.inputThreads(10)
                        .outputThreads(20)
                        .useGapless(false)
                        .recvBufferSize(DataSize.fromKiloBytes(1))
                )
                .withStreamingResourceParams(builder ->
                        builder.enableFullHd(true)
                )
                .run(() -> {
                    Assert.equals(
                            new StreamingParams(MediaTime.seconds(6), 5, 10,
                                    Duration.standardMinutes(1)),
                            sut.getStreamingParams()
                    );
                    Assert.equals(
                            new VideoInfoParams(true),
                            sut.getVideoInfoParams()
                    );
                    Assert.equals(
                            new FFmpegParams(Duration.standardMinutes(1), Duration.standardSeconds(10),
                                    Duration.standardSeconds(2), 12),
                            sut.getFFmpegParams()
                    );
                    Assert.equals(
                            new HlsFFmpegCommandParams(10, 20, false,
                                    DataSize.fromKiloBytes(1)),
                            sut.getFFmpegCommandParams()
                    );
                    Assert.equals(
                            new StreamingResourceParams(true),
                            sut.getStreamingResourceParams()
                    );
                    executed.set(true);
                });

        Assert.isTrue(executed.get(), "No checks were executed");
    }

    private static HlsParams consSut() {
        return new HlsParams(
                new StreamingParams(MediaTime.seconds(5), 1, 3,
                        Duration.standardSeconds(5)),
                new VideoInfoParams(false),
                new FFmpegParams(Duration.standardSeconds(30), Duration.standardSeconds(5), Duration.standardSeconds(1), 9),
                new HlsFFmpegCommandParams(2, 2, true, DataSize.MEGABYTE),
                new StreamingResourceParams(false)
        );
    }
}
