package ru.yandex.chemodan.videostreaming.framework.hls;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsRequest<T> extends DefaultObject {
    public final T sourceMeta;

    public final String filename;

    private final Option<HlsStreamQuality> qualityO;

    public HlsRequest(String filename, T sourceMeta, HlsStreamQuality quality) {
        this(filename, sourceMeta, Option.of(quality));
    }

    public HlsRequest(String filename, T sourceMeta, Option<HlsStreamQuality> qualityO) {
        this.sourceMeta = sourceMeta;
        this.filename = filename;
        this.qualityO = qualityO;
    }

    public T getSourceMeta() {
        return sourceMeta;
    }

    public HlsStreamQuality getQuality() {
        return qualityO.get();
    }

    public boolean hasQuality() {
        return qualityO.isPresent();
    }
}
