package ru.yandex.chemodan.videostreaming.framework.hls;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeFormat;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeInfo;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeSharedFixtures;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeStream;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsResourceTest {
    @Test
    public void getStreamQualitiesFor10pxVideo() {
        testGetStreamQualities(new Dimension(10, 10));
    }

    @Test
    public void getStreamQualitiesForVideoSmallerThan240p() {
        testGetStreamQualities(new Dimension(320, 180), HlsStreamQuality._240P);
    }

    @Test
    public void getStreamQualitiesFor480p() {
        testGetStreamQualities(
                new Dimension(640, 480),
                HlsStreamQuality._240P, HlsStreamQuality._360P, HlsStreamQuality._480P
        );
    }

    @Test
    public void getStreamQualitiesForVideoBetween480pAnd720p() {
        testGetStreamQualities(
                new Dimension(720, 500),
                HlsStreamQuality._240P, HlsStreamQuality._360P, HlsStreamQuality._480P, HlsStreamQuality._720P
        );
    }

    @Test
    public void getStreamQualitiesForVideoLargerThan1080p() {
        testGetStreamQualities(
                new Dimension(2880, 1620),
                HlsStreamQuality._240P, HlsStreamQuality._360P, HlsStreamQuality._480P, HlsStreamQuality._720P,
                HlsStreamQuality._1080P
        );
    }

    @Test
    public void getStreamQualitiesForAudio() {
        Assert.equals(
                HlsStreamQuality.AUDIO_QUALITIES,
                consAudioResource().getStreamQualities()
        );
    }

    @Test
    public void videoBitrateForAudioResourceMustBeEmpty() {
        Assert.none(consAudioResource().getVideoBitrateO());
    }

    private static void testGetStreamQualities(Dimension dimension, HlsStreamQuality... expectedQualities) {
        Assert.equals(Cf.list(expectedQualities), consVideoResource(dimension).getStreamQualities());
    }

    private static HlsResource consVideoResource(Dimension dimension) {
        return consVideoResource("mp42",
                FFprobeSharedFixtures.VIDEO_1080P_24FPS.toBuilder()
                        .codecName("h264")
                        .dimension(dimension)
                        .build()
        );
    }

    private static HlsResource consAudioResource() {
        return consVideoResource("mov,mp4,m4a,3gp,3g2,mj2",
                FFprobeSharedFixtures.AUDIO_STEREO_44KHZ.toBuilder()
                        .codecName("amr_nb")
                        .build()
        );
    }

    private static HlsResource consVideoResource(String containerFormat, FFprobeStream... streams) {
        FFprobeFormat format = FFprobeSharedFixtures.FORMAT_MKV_1HR.toBuilder()
                .name(containerFormat)
                .build();
        FFprobeInfo info = new FFprobeInfo(format, Cf.list(streams));
        return new HlsResource(new MediaInfo(info, ""));
    }
}
