package ru.yandex.chemodan.videostreaming.framework.hls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.io.IoUtils;
import ru.yandex.misc.io.http.HttpHeaderNames;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.web.servlet.HttpServletRequestX;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsResponse extends DefaultObject {
    @SuppressWarnings({"unused", "FieldCanBeLocal"})
    private final HttpServletRequestX req;

    private final HttpServletResponseX resp;

    @SuppressWarnings({"unused", "FieldCanBeLocal"})
    private final SetF<String> corsWhitelist;

    public HlsResponse(HttpServletRequestX req, HttpServletResponseX resp) {
        this(req, resp, Cf.set());
    }

    public HlsResponse(HttpServletRequestX req, HttpServletResponseX resp, SetF<String> corsWhitelist) {
        this.req = req;
        this.resp = resp;
        this.corsWhitelist = corsWhitelist;
    }

    public void consumePlaylist(String playlistContents) {
        consumeContent(playlistContents.getBytes(), "application/vnd.apple.mpegurl");
    }

    public void consumeContent(byte[] content, String mediaType) {
        handleResponse(
                new ByteArrayInputStream(content),
                mediaType,
                content.length
        );
    }

    @SuppressWarnings("SameParameterValue")
    public void handleResponse(InputStream in, String mediaType) {
        handleResponse(in, mediaType, Option.empty());
    }

    private void handleResponse(InputStream in, String mediaType, int length) {
        handleResponse(in, mediaType, Option.of(length));
    }

    private void handleResponse(InputStream in, String mediaType, Option<Integer> length) {
        handleOk();
        resp.setContentType(mediaType);
        if (length.isPresent()) {
            resp.setContentLength(length.get());
        }

        addCorsHeaders();

        try {
            IoUtils.copy(in, resp.getOutputStream());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void addCorsHeaders() {
//        Option<String> originO = req.getHeaderO(HttpHeaderNames.ORIGIN);
//        if (originO.filterMap(HlsResponse::extractHostSafeO).isMatch(corsWhitelist::containsTs)) {
//            resp.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, originO.get());
//        } else if (!originO.isPresent()) {
//            resp.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, "*");
//        }
        resp.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, "*");

        resp.setHeader(HttpHeaderNames.ALLOW, "GET, HEAD, OPTIONS");
        resp.setHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, "Accept-Encoding, DNT");
    }

    static Option<String> extractHostSafeO(String uri) {
        try {
            return Option.ofNullable(UrlUtils.uri(uri).getHost());
        } catch(RuntimeException ex) {
            return Option.empty();
        }
    }

    public void handleOk() {
        resp.setStatus(HttpStatus.SC_200_OK);
    }

    public void handleBadRequest() {
        resp.setStatus(HttpStatus.SC_400_BAD_REQUEST);
    }
}
