package ru.yandex.chemodan.videostreaming.framework.hls;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.regex.Matcher2;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsSegmentId extends DefaultObject {
    private static final Pattern2 segmentFilenamePattern = Pattern2.compile("^(prefetch|local)?([0-9]+)\\.(ts|aac)$");

    public final int index;

    public final Type type;

    private HlsSegmentId(int index, Type type) {
        this.index = index;
        this.type = type;
    }

    public static Option<HlsSegmentId> parseFilenameO(String filename) {
        Matcher2 matcher = segmentFilenamePattern.matcher2(filename);
        return Option.when(matcher.matches(),
                () -> parse(matcher.groups())
        );
    }

    private static HlsSegmentId parse(ListF<String> groups) {
        return new HlsSegmentId(
                Integer.parseInt(groups.get(1)),
                Type.byPrefix(groups.first())
        );
    }

    @Override
    public String toString() {
        return type.prefix + index;
    }

    public enum Type {
        BASIC(""), PREFETCH("prefetch"), LOCAL("local");

        private final String prefix;

        Type(String prefix) {
            this.prefix = prefix;
        }

        static Type byPrefix(String prefix) {
            return Cf.list(values())
                    .find(type -> type.prefix.equals(prefix))
                    .getOrThrow(
                            () -> new IllegalArgumentException("Unknown prefix = " + prefix)
                    );
        }
    }
}
