package ru.yandex.chemodan.videostreaming.framework.hls;

import java.math.BigDecimal;

import org.joda.time.DateTimeConstants;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmtiriy Amelin (lemeh)
 */
public class HlsSegmentMeta<T> extends DefaultObject {
    public static final BigDecimal MILLIS_PER_SECOND = BigDecimal.valueOf(DateTimeConstants.MILLIS_PER_SECOND);

    public final transient HlsResource.Stream stream;

    public final HlsSegmentRegion region;

    public final T sourceMeta;

    public HlsSegmentMeta(HlsResource.Stream stream, HlsSegmentRegion region, T sourceMeta) {
        this.stream = stream;
        this.region = region;
        this.sourceMeta = sourceMeta;
    }

    public Option<HlsSegmentMeta<T>> getSiblingIfExistsO(int offset) {
        return region.getSiblingIfValidO(offset)
                .map(siblingRegion -> new HlsSegmentMeta<>(stream, siblingRegion, sourceMeta));
    }

    public HlsStreamQuality getQuality() {
        return stream.getQuality();
    }

    public int getIndex() {
        return region.getIndex();
    }

    public MediaTime getDuration() {
        return region.getDuration();
    }

    public MediaInfo getFileInformation() {
        return stream.getFileInformation();
    }

    public T getSourceMeta() {
        return sourceMeta;
    }

    public MediaTime getActualDuration() {
        return region.getActualDuration();
    }

    @Override
    public String toString() {
        return String.format("%s/%s", sourceMeta, region);
    }
}
