package ru.yandex.chemodan.videostreaming.framework.hls;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsSegmentRegion extends DefaultObject {
    private final int index;

    private final MediaSegmentation segmentation;

    public HlsSegmentRegion(int index, MediaTime duration, HlsResource.Stream stream) {
        this(index, MediaSegmentation.fromSegmentAndTotalDurations(duration, stream.getTotalDuration()));
    }

    HlsSegmentRegion(int index, MediaTime duration, MediaTime totalDuration) {
        this(index, new MediaSegmentation(duration, totalDuration));
    }

    private HlsSegmentRegion(int index, MediaSegmentation segmentation) {
        this.index = index;
        this.segmentation = segmentation;
    }

    public int getIndex() {
        return index;
    }

    public MediaTime getStart() {
        return getDuration().multipliedBy(getIndex());
    }

    @SuppressWarnings("unused")
    public MediaTime getEnd() {
        return getDuration().multipliedBy(getIndex() + 1);
    }

    public MediaTime getDuration() {
        return segmentation.getSegmentDuration();
    }

    public MediaTime getTotalDuration() {
        return segmentation.getTotalDuration();
    }

    public MediaTime getActualDuration() {
        return segmentation.getActualSegmentDuration(index);
    }

    @SuppressWarnings("unused")
    public boolean isFirst() {
        return getIndex() == 0;
    }

    public boolean isLast() {
        return segmentation.isLastSegment(index);
    }

    public boolean startsBefore(MediaTime start) {
        return getStart().isShorterThan(start);
    }

    public HlsSegmentRegion getSibling(int offset) {
        return new HlsSegmentRegion(index + offset, segmentation);
    }

    Option<HlsSegmentRegion> getSiblingIfValidO(int offset) {
        return getSibling(offset).ifValidO();
    }

    private Option<HlsSegmentRegion> ifValidO() {
        return Option.when(isValid(), this);
    }

    private boolean isValid() {
        return index >= 0 && startsBefore(getTotalDuration());
    }
}
