package ru.yandex.chemodan.videostreaming.framework.hls;

import org.junit.Test;

import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsSegmentRegionTest {
    private static final MediaTime SEGMENT_DURATION = MediaTime.seconds(5);

    private static final MediaTime TOTAL_DURATION = MediaTime.seconds(16);

    @Test
    public void getSiblingIfValidO() {
        assertHasNoSibling(1, -2);
        assertHasSibling(1, -1, 0);
        assertHasSibling(1, 0, 1);
        assertHasSibling(1, +1, 2);
        assertHasSibling(1, +2, 3);
        assertHasNoSibling(1, +3);
    }

    private static void assertHasNoSibling(int baseIndex, int offset) {
        Assert.none(consRegion(baseIndex).getSiblingIfValidO(offset));
    }

    private static void assertHasSibling(int baseIndex, int offset, int siblingIndex) {
        Assert.some(consRegion(siblingIndex), consRegion(baseIndex).getSiblingIfValidO(offset));
    }

    private static HlsSegmentRegion consRegion(int baseIndex) {
        return new HlsSegmentRegion(baseIndex, SEGMENT_DURATION, TOTAL_DURATION);
    }
}
