package ru.yandex.chemodan.videostreaming.framework.hls;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsStreamQualityTest {
    @Test
    public void parseONumericUpperP() {
        Assert.equals(
                Option.of(HlsStreamQuality._240P),
                HlsStreamQuality.parseO("240P")
        );
    }

    @Test
    public void parseONumericLowerP() {
        Assert.equals(
                Option.of(HlsStreamQuality._240P),
                HlsStreamQuality.parseO("240p")
        );
    }

    @Test
    public void parseODefault() {
        Assert.equals(
                Option.of(HlsStreamQuality._DEFAULT),
                HlsStreamQuality.parseO("default")
        );
    }

    @Test(expected = IllegalArgumentException.class)
    public void parseThrowsErrorWhenUnknownDimension() {
        HlsStreamQuality.parse("abc");
    }

    @Test
    public void numericQualityToRequestParamValue() {
        Assert.equals("240p", HlsStreamQuality._240P.toRequestParamValue());
    }

    @Test
    public void defaultQualityToRequestParamValue() {
        Assert.equals("default", HlsStreamQuality._DEFAULT.toRequestParamValue());
    }

    @Test
    public void possibleQualitiesMiddleCase() {
        Assert.equals(
                Cf.list(HlsStreamQuality._240P, HlsStreamQuality._360P),
                HlsStreamQuality.getSuitableFor(new Dimension(400, 241))
        );
    }

    @Test
    public void possibleQualitiesBoundary() {
        Assert.equals(
                HlsStreamQuality.MASTER_QUALITIES,
                HlsStreamQuality.getSuitableFor(new Dimension(1920, 1080))
        );
    }
}
