package ru.yandex.chemodan.videostreaming.framework.hls;

import java.net.URI;

import ru.yandex.bolts.collection.Tuple2List;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface HlsUrlBuilder<T> {
    URI getMasterPlaylistUrl(T sourceMeta, StreamingUrlParams urlParams);

    URI getPlaylistUrl(T sourceMeta, HlsStreamQuality quality, StreamingUrlParams urlParams);

    String getRelativePlaylistItemUri(String filename, Tuple2List<String, String> extraParams);

    default URI getMasterPlaylistUrl(T sourceMeta) {
        return getMasterPlaylistUrl(sourceMeta, StreamingUrlParams.getCurrent());
    }

    default URI getPlaylistUrl(T sourceMeta, HlsStreamQuality quality) {
        return getPlaylistUrl(sourceMeta, quality, StreamingUrlParams.getCurrent());
    }

    default String getRelativePlaylistItemUri(String filename) {
        return getRelativePlaylistItemUri(filename, Tuple2List.tuple2List());
    }
}
