package ru.yandex.chemodan.videostreaming.framework.hls;

import org.junit.Test;

import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class MediaSegmentationTest {
    private static final MediaTime SEGMENT_DURATION = MediaTime.seconds(5);

    @Test
    public void getSegmentCount() {
        assertSegmentCountEquals(3, 15);
        assertSegmentCountEquals(1, 2);
        assertSegmentCountEquals(0, 0);
        assertSegmentCountEquals(2, 6);
    }

    private void assertSegmentCountEquals(int expectedSegmentCount, long totalDuration) {
        Assert.equals(
                expectedSegmentCount,
                MediaSegmentation.fromSegmentAndTotalDurations(SEGMENT_DURATION, MediaTime.seconds(totalDuration))
                        .getSegmentCount()
        );
    }

    @Test
    public void tooSmallTimeRemainder() {
        MediaSegmentation mediaSegmentation =
                MediaSegmentation.fromSegmentAndTotalDurations(SEGMENT_DURATION,
                        SEGMENT_DURATION.multipliedBy(3).plus(10));
        Assert.equals(3, mediaSegmentation.getSegmentCount());
        Assert.equals(SEGMENT_DURATION.plus(10), mediaSegmentation.getActualSegmentDuration(2));
    }

    @Test
    public void enoughTimeRemainder() {
        MediaSegmentation mediaSegmentation =
                MediaSegmentation.fromSegmentAndTotalDurations(SEGMENT_DURATION,
                        SEGMENT_DURATION.multipliedBy(4).plus(MediaTime.seconds(1)));
        Assert.equals(5, mediaSegmentation.getSegmentCount());
        Assert.equals(MediaTime.seconds(1), mediaSegmentation.getActualSegmentDuration(4));
    }
}
