package ru.yandex.chemodan.videostreaming.framework.hls;

import java.net.URI;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.io.http.UriBuilder;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ServerUriUtil {
    public static final Tuple2List<String, Integer> SCHEME_PORT_HIDE =
            Tuple2List.fromPairs("http", 80, "https", 443);

    public static Option<URI> extractServerUriO(HttpServletRequest r) {
        String scheme = r.getScheme();
        String serverName = r.getServerName();
        int port = r.getServerPort();
        if (scheme == null || serverName == null || port <= 0) {
            return Option.empty();
        }
        return Option.of(buildServerUri(scheme, serverName, port));
    }

    private static URI buildServerUri(String scheme, String serverName, int port) {
        return new UriBuilder()
                .setScheme(scheme.toLowerCase())
                .setHost(serverName.toLowerCase())
                .setPort(getEffectivePort(scheme, port))
                .build();
    }

    private static int getEffectivePort(String scheme, int port) {
        return SCHEME_PORT_HIDE.containsTs(new Tuple2<>(scheme.toLowerCase(), port)) ? -1 : port;
    }
}
