package ru.yandex.chemodan.videostreaming.framework.hls;

import java.net.URI;

import javax.servlet.http.HttpServletRequest;

import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ServerUriUtilTest {
    @Test
    public void serverUriMustBeEmptyWhenSchemeIsNull() {
        Assert.none(doExtractServerUriO(null, "servername", 80));
    }

    @Test
    public void serverUriMustBeEmptyWhenServerNameIsNull() {
        Assert.none(doExtractServerUriO("http", null, 80));
    }

    @Test
    public void serverUriMustBeEmptyWhenServerPortIsZero() {
        Assert.none(doExtractServerUriO("http", "servername", 0));
    }

    @Test
    public void serverUriMustBeSomeWhenSchemeIsHttpAndValuesAreNotEmpty() {
        Assert.some(
                new UriBuilder("http://servername").build(),
                doExtractServerUriO("http", "servername", 80)
        );
    }

    @Test
    public void serverUriMustBeSomeWhenSchemeIsHttpsAndValuesAreNotEmpty() {
        Assert.some(
                new UriBuilder("https://servername").build(),
                doExtractServerUriO("https", "servername", 443)
        );
    }

    @Test
    public void serverUriMustBeSomeWithPortWhenNonStandardPortSpecifiedAndValuesAreNotEmpty() {
        Assert.some(
                new UriBuilder("http://servername:8080").build(),
                doExtractServerUriO("http", "servername", 8080)
        );
    }

    private static Option<URI> doExtractServerUriO(String scheme, String serverName, int serverPort) {
        return ServerUriUtil.extractServerUriO(consHttpServletRequestMock(scheme, serverName, serverPort));
    }


    private static HttpServletRequest consHttpServletRequestMock(String scheme, String serverName, int serverPort) {
        HttpServletRequest requestMock = Mockito.mock(HttpServletRequest.class);
        Mockito.when(requestMock.getScheme())
                .thenReturn(scheme);
        Mockito.when(requestMock.getServerName())
                .thenReturn(serverName);
        Mockito.when(requestMock.getServerPort())
                .thenReturn(serverPort);
        return requestMock;
    }
}
