package ru.yandex.chemodan.videostreaming.framework.hls;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeFormat;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeInfo;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeStream;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;
import ru.yandex.chemodan.videostreaming.framework.media.units.BitRate;
import ru.yandex.chemodan.videostreaming.framework.media.units.FrameRate;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.chemodan.videostreaming.framework.media.units.SampleFrequency;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ShortFileInformationTest {
    @Test
    public void testToJson() {
        FFprobeFormat format = FFprobeFormat.builder()
                .name("mov,mp4,m4a,3gp,3g2,mj2")
                .duration(MediaTime.millis(175180))
                .bitRate(new BitRate(9904128))
                .build();
        FFprobeStream.Video videoStream = FFprobeStream.Video.builder()
                .codecName("h264")
                .dimension(new Dimension(816, 1920))
                .avgFrameRate(new FrameRate(24000, 1001))
                .rFrameRate(new FrameRate(24000, 1001))
                .bitRate(new BitRate(9772032))
                .build();
        FFprobeStream.Audio audioStream = FFprobeStream.Audio.builder()
                .codecName("aac")
                .channels(2)
                .channelLayout("stereo")
                .sampleRate(new SampleFrequency(44100))
                .bitRate(new BitRate(125952))
                .build();
        FFprobeInfo info = new FFprobeInfo(format, Cf.list(videoStream, audioStream));
        Assert.equals(
                ("{"
                        + "\"fmt\":\"mov,mp4,m4a,3gp,3g2,mj2\","
                        + "\"len\":175180,"
                        + "\"bps\":9904128,"
                        + "\"video\":{"
                            + "\"codec\":\"h264\","
                            + "\"bps\":9772032,"
                            + "\"size\":\"816x1920\","
                            + "\"fps\":\"24000/1001\""
                        + "},"
                        + "\"audio\":{"
                            + "\"codec\":\"aac\","
                            + "\"bps\":125952,"
                            + "\"stereo\":true,"
                            + "\"chn\":2,"
                            + "\"freq\":44100"
                        + "}"
                + "}"),
                ShortFileInformation.cons(new MediaInfo(info, ""))
                        .toJsonStr()
        );
    }
}
