package ru.yandex.chemodan.videostreaming.framework.hls;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import lombok.experimental.NonFinal;
import org.joda.time.Duration;

import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Value
@NonFinal
@AllArgsConstructor
@Builder(toBuilder = true)
public class StreamingParams {
    MediaTime segmentDuration;

    int initPrefetchSize;

    int maxPrefetchSize;

    Duration maxCacheWait;

    boolean deleteCache;

    boolean disableDynamicPrefetch;

    boolean cacheDisabled;

    boolean fetchSegmentFromMaster;

    boolean useFloatSegmentDurations;

    public StreamingParams(MediaTime segmentDuration, int initPrefetchSize, int maxPrefetchSize,
            Duration maxCacheWait)
    {
        this(segmentDuration, initPrefetchSize, maxPrefetchSize, maxCacheWait, false);
    }

    public StreamingParams(MediaTime segmentDuration, int initPrefetchSize, int maxPrefetchSize,
            Duration maxCacheWait, boolean useFloatSegmentDurations)
    {
        this(segmentDuration, initPrefetchSize, maxPrefetchSize, maxCacheWait,
                false, false, false, false, useFloatSegmentDurations);
    }
}
