package ru.yandex.chemodan.videostreaming.framework.hls;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Value
@AllArgsConstructor
@Builder(toBuilder = true)
@BenderBindAllFields
public class TranscodeParams {
    public static final TranscodeParams DEFAULT =
            new TranscodeParams("default", false, false, false,
                    false, false, Option.empty());

    String argFillerName;

    @BenderDefaultValue("false")
    boolean ffmpegLogEnabled;

    @BenderDefaultValue("false")
    boolean enableFullHd;

    @BenderDefaultValue("false")
    boolean disableCache;

    @BenderDefaultValue("false")
    boolean enableSeparateAudio;

    @BenderDefaultValue("false")
    boolean useFloatSegmentDurations;

    @Getter(AccessLevel.NONE) Option<String> ffmpegVersionO;

    public Option<String> getFFmpegVersionO() {
        return ffmpegVersionO;
    }
}
