package ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.receiver;

import java.util.UUID;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFmpegReceiverUploadMeta extends DefaultObject {
    final UUID sessionId;

    final String filename;

    public FFmpegReceiverUploadMeta(UUID sessionId, String filename) {
        this.sessionId = sessionId;
        this.filename = filename;
    }

    public static FFmpegReceiverUploadMeta parse(String pathInfo) {
        ListF<String> chunks = Cf.list(pathInfo.split("/"));
        int length = chunks.length();
        String filename = chunks.get(length - 1);
        String sessionId = chunks.get(length - 2);
        return new FFmpegReceiverUploadMeta(UUID.fromString(sessionId), filename);
    }
}
