package ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFmpegMapping extends DefaultObject {
    private final Option<String> videoMapping;

    private final Option<String> audioMapping;

    public FFmpegMapping(Option<String> videoMapping, Option<String> audioMapping) {
        this.videoMapping = videoMapping;
        this.audioMapping = audioMapping;
    }

    public static FFmpegMapping fromFileInfo(MediaInfo fileInfo) {
        return new FFmpegMapping(
                fileInfo.getVideoStreamO().map(MediaInfo.Stream::getId),
                fileInfo.getAudioStreamO().map(MediaInfo.Stream::getId)
        );
    }

    public ListF<String> getArgs() {
        ListF<String> result = Cf.list();
        result = addMapping(result, videoMapping);
        result = addMapping(result, audioMapping);
        return result;
    }

    private static ListF<String> addMapping(ListF<String> mapArgs, Option<String> mapping) {
        return mapping.isPresent() ? mapArgs.plus("-map", "0:" + mapping.get()) : mapArgs;
    }
}
