package ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsResource;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsStreamQuality;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;
import ru.yandex.chemodan.videostreaming.framework.media.units.BitRate;
import ru.yandex.chemodan.videostreaming.framework.media.units.FrameRate;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.image.Dimension;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsFFmpegCommandContext {
    private final HlsFFmpegCommandParams params;

    private final HlsResource.Stream stream;

    private final Option<FFmpegMapping> mappingO;

    private final HlsMuxerSegmentOpts segment;

    public HlsFFmpegCommandContext(HlsResource.Stream stream, HlsMuxerSegmentOpts segment,
            HlsFFmpegCommandParams params, FFmpegMapping mapping)
    {
        this(stream, params, Option.of(mapping), segment);
    }

    private HlsFFmpegCommandContext(HlsResource.Stream stream, HlsFFmpegCommandParams params,
                        Option<FFmpegMapping> mappingO, HlsMuxerSegmentOpts segment)
    {
        this.stream = stream;
        this.params = params;
        this.mappingO = mappingO;
        this.segment = segment;
    }

    @SuppressWarnings("unused")
    public MediaInfo getMediaInfo() {
        return stream.getFileInformation();
    }

    public boolean isUseGapless() {
        return params.isUseGapless();
    }

    public int getInThreads() {
        return params.getInputThreads();
    }

    public int getOutThreads() {
        return params.getOutputThreads();
    }

    public DataSize getRecvBufferSize() {
        return params.getRecvBufferSize();
    }

    public Option<FFmpegMapping> getMappingO() {
        return mappingO;
    }

    public boolean hasVideo() {
        return getDimension().getSquare() > 0;
    }

    public BitRate getVideoBitRate() {
        return stream.getVideoBitrate();
    }

    public Dimension getDimension() {
        return stream.getDimension();
    }

    public Option<FrameRate> getFrameRateO() {
        return stream.getFrameRateO();
    }

    public boolean isAudioRequested() {
        return stream.getQuality() == HlsStreamQuality._AAC;
    }

    public boolean hasAudio() {
        return getAudioBitRateO().isPresent();
    }

    public Option<BitRate> getAudioBitRateO() {
        return stream.getAudioBitrateO();
    }

    public MediaTime getOutDuration() {
        return segment.getOutputDuration();
    }

    public boolean isNotFirstSegment() {
        return !segment.isFirst();
    }

    public boolean isLast() {
        return segment.isLast();
    }

    public MediaTime getSegmentStart() {
        return segment.getStart();
    }

    public MediaTime getSegmentDuration() {
        return segment.getSegmentDuration();
    }

    public Integer getSegmentStartNumber() {
        return segment.getSegmentStartNumber();
    }
}
